/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.TextureType;
import team.chisel.ctm.api.client.TextureTypeRegistry;
import team.chisel.ctm.client.resource.CTMMetadataSection;
import team.chisel.ctm.client.texture.type.TextureTypeNormal;

public class CTMMetadataSectionV1
implements CTMMetadataSection {
    private TextureType type = TextureTypeNormal.INSTANCE;
    private BlendMode blendMode = BlendMode.DEFAULT;
    private class_2960[] additionalTextures;
    private class_2960 proxy;
    private JsonObject extraData;

    public static CTMMetadataSection fromJson(JsonObject jsonObject) throws JsonParseException {
        return CTMMetadataSectionV1.fromJson(jsonObject, class_2960::new);
    }

    public static CTMMetadataSection fromJson(JsonObject jsonObject, Function<String, class_2960> identifierProvider) throws JsonParseException {
        JsonElement texturesElement;
        JsonElement layerElement;
        JsonElement typeElement;
        CTMMetadataSectionV1 metadata = new CTMMetadataSectionV1();
        if (jsonObject.has("proxy")) {
            JsonElement proxyElement = jsonObject.get("proxy");
            if (proxyElement.isJsonPrimitive() && proxyElement.getAsJsonPrimitive().isString()) {
                String proxyString = proxyElement.getAsString();
                try {
                    metadata.proxy = identifierProvider.apply(proxyString);
                }
                catch (class_151 e) {
                    throw new JsonParseException("Invalid proxy identifier provided: " + proxyString);
                }
            }
            if (jsonObject.entrySet().stream().filter(element -> !((String)element.getKey()).equals("ctm_version")).count() > 1L) {
                throw new JsonParseException("Cannot define other fields when using proxy");
            }
        }
        if (jsonObject.has("type") && (typeElement = jsonObject.get("type")).isJsonPrimitive() && typeElement.getAsJsonPrimitive().isString()) {
            TextureType type = TextureTypeRegistry.INSTANCE.getType(typeElement.getAsString());
            if (type == null) {
                throw new JsonParseException("Invalid texture type provided: " + typeElement);
            }
            metadata.type = type;
        }
        if (jsonObject.has("layer") && (layerElement = jsonObject.get("layer")).isJsonPrimitive() && layerElement.getAsJsonPrimitive().isString()) {
            try {
                metadata.blendMode = BlendMode.valueOf((String)layerElement.getAsString().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Invalid render layer provided: " + layerElement);
            }
        }
        if (jsonObject.has("textures") && (texturesElement = jsonObject.get("textures")).isJsonArray()) {
            JsonArray texturesArray = texturesElement.getAsJsonArray();
            metadata.additionalTextures = new class_2960[texturesArray.size()];
            for (int i = 0; i < texturesArray.size(); ++i) {
                JsonElement textureElement = texturesArray.get(i);
                if (!textureElement.isJsonPrimitive() || !textureElement.getAsJsonPrimitive().isString()) continue;
                String textureString = textureElement.getAsString();
                try {
                    metadata.additionalTextures[i] = identifierProvider.apply(textureString);
                    continue;
                }
                catch (class_151 e) {
                    throw new JsonParseException("Invalid texture identifier provided: " + textureString);
                }
            }
        }
        if (metadata.additionalTextures == null) {
            metadata.additionalTextures = new class_2960[0];
        }
        if (jsonObject.has("extra") && jsonObject.get("extra").isJsonObject()) {
            metadata.extraData = jsonObject.getAsJsonObject("extra");
        }
        return metadata;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public TextureType getType() {
        return this.type;
    }

    @Override
    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public class_2960[] getAdditionalTextures() {
        return this.additionalTextures;
    }

    @Override
    @Nullable
    public class_2960 getProxy() {
        return this.proxy;
    }

    @Override
    @Nullable
    public JsonObject getExtraData() {
        return this.extraData;
    }

    public String toString() {
        return "CTMMetadataSectionV1(type=" + this.getType() + ", blendMode=" + this.getBlendMode() + ", additionalTextures=" + Arrays.deepToString(this.getAdditionalTextures()) + ", proxy=" + this.getProxy() + ", extraData=" + this.getExtraData() + ")";
    }
}

